
//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples, 
//we welcome you to contact us at SampleCode@melissadata.com also please visit our 
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace AddressObjectSample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // ********************** DATA FILE PATH  ***********************
        //  File location path is set to the default Data File location. 
        //  Change this value if you installed the data files to a       
        //  different folder.                                            
        //  The Data Files Directory must contain the following files:   
        //  mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str
        // **************************************************************
        public string DataPathLocation = @"C:\Program Files\Melissa Data\DQT\Data";

        // ********************** LICENSE STRINGS ***********************
        //       To unlock the full function ality of Address Object,   
        //   please call a sales representative at 1-800-MELISSA ext. 3 
        //           (1-800-635-4772 x3) for a license string.          
        //        Without a valid license string, AddressCheck will     
        //                  only verify Nevada addresses.               
        //              REPLACE "DEMO" with LICENSE STRING                    

        //   SetLicenseString will also check for a valid license in the 
        //   MDADDR_LICENSE(Environment) variable. This allows you to  
        //   modify the license without recompiling the project
        // **************************************************************
        public string LicenseString = "Demo";

        //Address Object Interfaces
        public ADDRESSOBJECTLib.AddressCheckClass addrobj;
        public ADDRESSOBJECTLib.ParseClass parseObj;
        public ADDRESSOBJECTLib.ZipCodeDataClass zipObj;
        public ADDRESSOBJECTLib.StreetDataClass streetObj;

        #region Initialize Objects
        private void Form1_Load(object sender, System.EventArgs e)
        {
            //****Initialize Address Object Address Check Interface****//
            addrobj = new ADDRESSOBJECTLib.AddressCheckClass();
            addrobj.SetLicenseString(LicenseString);

            //Set Path To Data Files
            addrobj.SetPathToUSFiles(DataPathLocation);

            //CASS required add-ons for highest level of validation. Should be used by non-demo users.
            //addrobj.SetPathToDPVFiles(DataPathLocation);
            //addrobj.SetPathToLACSLinkDataFiles(DataPathLocation);
            //addrobj.SetPathToSuiteLinkDataFiles(DataPathLocation);

            //addrobj.SetPathToCanadaFiles(DataPathLocation);		     //Canadian Address Add-on
            //addrobj.SetPathToRBDIFiles(DataPathLocation);			     //Residential Business Delivery Indicator Add-on
            //addrobj.SetPathToSuiteFinderDataFiles(DataPathLocation);   //AddressPlus Add-on (appends residential suites)

            if (addrobj.InitializeDataFiles() != 0)
            {
                //Initialization failed
                lblInitError.Text = addrobj.GetInitializeErrorString();
                btnVerify.Enabled = false;
            }
            else
            {
                //Initialized
                btnVerify.Enabled = true;
                lblBuild.Text = addrobj.GetBuildNumber();
                lblDatabaseDate.Text = addrobj.GetDatabaseDate().ToShortDateString();
                lblExpiration.Text = addrobj.GetUSExpirationDate().ToShortDateString();
            }



            //****Initialize Address Object Parse  Interface****//
            parseObj = new ADDRESSOBJECTLib.ParseClass();
            //Load Suffix File, not necessary but highly recommended
            //Will increate parse accuracy with mispelled suffixes
            parseObj.Initialize(DataPathLocation);


            //****Initialize Address Object Street Data Interface****//
            streetObj = new ADDRESSOBJECTLib.StreetDataClass();
            streetObj.SetLicenseString(LicenseString);
            if (streetObj.Initialize(DataPathLocation, DataPathLocation, "") != 0)
            {
                // Initialize failed
                lblStreetInitError.Text = streetObj.GetInitializeErrorString();
                btnFindStreet.Enabled = false;
            }
            else
            {
                btnFindStreet.Enabled = true;
                lblStreetBuild.Text = streetObj.GetBuildNumber();
                lblStreetDatabaseDate.Text = streetObj.GetDatabaseDate().ToShortDateString();
                lblStreetInitError.Text = streetObj.GetInitializeErrorString();
            }




            //****Initialize Address Object Zip Data Interface****//
            zipObj = new ADDRESSOBJECTLib.ZipCodeDataClass();
            zipObj.SetLicenseString(LicenseString);
            if (zipObj.Initialize(DataPathLocation, DataPathLocation, "") != 0)
            {
                // Initialize failed
                lblZipErrorString.Text = zipObj.GetInitializeErrorString();
                btnCityInState.Enabled = false;
                btnZipInCity.Enabled = false;
                btnFindZip.Enabled = false;
            }
            else
            {
                // Initialize successful
                lblZipBuild.Text = zipObj.GetBuildNumber();
                lblZipDatabase.Text = zipObj.GetDatabaseDate().ToShortDateString();
                lblZipErrorString.Text = zipObj.GetInitializeErrorString();
                btnCityInState.Enabled = true;
                btnZipInCity.Enabled = true;
                btnFindZip.Enabled = true;
            }
        }
        #endregion

        #region Address Check
        private void btnVerify_Click(object sender, System.EventArgs e)
        {
            //clear any previous results
            AddressClear();

            //set input address
            addrobj.ClearProperties();
            addrobj.Company = txtCompany.Text;
            addrobj.Address = txtAddress.Text;
            addrobj.Address2 = txtAddress2.Text;
            addrobj.City = txtCity.Text;
            addrobj.State = txtState.Text;
            addrobj.Zip = txtZip.Text;
            addrobj.LastName = txtLastName.Text;

            //verify address
            addrobj.VerifyAddress();

            //set results
            txtCompanyOut.Text = addrobj.Company;
            txtAddressOut.Text = addrobj.Address;
            txtAddress2Out.Text = addrobj.Address2;
            txtSuite.Text = addrobj.Suite;
            txtCityOut.Text = addrobj.City;
            txtStateOut.Text = addrobj.State;
            txtZipOut.Text = addrobj.Zip;
            txtPlus4.Text = addrobj.Plus4;

            // Get the Result Codes
            String ResultsString = addrobj.Results;
            String ResultsOut = "";
            if ((ResultsString.Contains("AS01")) || (ResultsString.Contains("AS02")) || (ResultsString.Contains("AS03"))) 
            {
                // Address was verified .
                if (ResultsString.Contains("AS01"))
                    ResultsOut = "AS01: Full Address Matched to Postal Database and is deliverable\r\n";
                if (ResultsString.Contains("AS02"))
                    ResultsOut = "AS02: Address Matched to Postal Database, but suite missing or invalid\r\n";
                if (ResultsString.Contains("AS03"))
                    ResultsOut += "AS03: Valid Physical Address, not Serviced by the USPS \r\n";
                txtResultCodes.ForeColor = Color.Green;
            } else
                //address could not be verified
                txtResultCodes.ForeColor = Color.Red;

            // Display additional level of verification/comments
            
            if (ResultsString.Contains("AS09"))
                 ResultsOut += "AS09: Foreign Postal Code Detected \r\n";
            if (ResultsString.Contains("AS10"))
                 ResultsOut += "AS10: Address Matched to CMRA\r\n";
            if (ResultsString.Contains("AS13"))
                 ResultsOut += "AS13: Address has been Updated by LACSLink \r\n";
            if (ResultsString.Contains("AS14"))
                 ResultsOut += "AS14: Suite Appended by SuiteLink \r\n";
            if (ResultsString.Contains("AS15"))
                 ResultsOut += "AS15: Suite Appended by SuiteFinder \r\n";
            if (ResultsString.Contains("AS16"))
                 ResultsOut += "AS16: Address is vacant.\r\n";
            if (ResultsString.Contains("AS17"))
                 ResultsOut += "AS17: Alternate delivery.\r\n";
            if (ResultsString.Contains("AS18"))
                 ResultsOut += "AS18: Artificially created adresses detected,DPV processing terminated at this point\r\n";
            if (ResultsString.Contains("AS20"))
                 ResultsOut += "AS20: Address Deliverable by USPS only \r\n";
            if (ResultsString.IndexOf("AS21") != -1)
                 ResultsOut += "AS21: Alternate Address Suggestion Found\r\n";
            if (ResultsString.IndexOf("AS22") != -1)
                 ResultsOut += "AS22: No Alternate Address Suggestion Found\r\n";
            if (ResultsString.IndexOf("AS23") != -1)
                 ResultsOut += "AS23: Extraneous information found \r\n";   
            
            if (ResultsString.Contains("AE"))
            {
                // there was an error in verifying the address
                if (ResultsString.Contains("AE01"))
                    ResultsOut += "AE01: Zip Code Error \r\n";
                if (ResultsString.Contains("AE02"))
                    ResultsOut += "AE02: Unknown Street Error \r\n";
                if (ResultsString.Contains("AE03"))
                    ResultsOut += "AE03: Component Mismatch Error \r\n";
                if (ResultsString.Contains("AE04"))
                    ResultsOut += "AE04: Non-Deliverable Address Error \r\n";
                if (ResultsString.Contains("AE05"))
                    ResultsOut += "AE05: Multiple Match Error \r\n";
                if (ResultsString.Contains("AE06"))
                    ResultsOut += "AE06: Early Warning System Error \r\n";
                if (ResultsString.Contains("AE07"))
                    ResultsOut += "AE07: Missing Minimum Address Input \r\n";
                if (ResultsString.Contains("AE08"))
                    ResultsOut += "AE08: Suite Range Invalid Error\r\n";
                if (ResultsString.Contains("AE09"))
                    ResultsOut += "AE09: Suite Range Missing Error \r\n";
                if (ResultsString.Contains("AE10"))
                    ResultsOut += "AE10: Primary Range Invalid Error \r\n";
                if (ResultsString.Contains("AE11"))
                    ResultsOut += "AE11: Primary Range Missing Error \r\n";
                if (ResultsString.Contains("AE12"))
                    ResultsOut += "AE12: PO, HC, or RR Box Number Invalid \r\n";
                if (ResultsString.Contains("AE13"))
                    ResultsOut += "AE13: PO, HC, or RR Box Number Missing \r\n";
                if (ResultsString.Contains("AE14"))
                    ResultsOut += "AE14: CMRA Secondary Missing Error\r\n";

                // program can not attempt address lookup
                if (ResultsString.Contains("AE15"))
                    ResultsOut += "AE15: Demo Mode, valid license required for full processing\r\n";
                if (ResultsString.Contains("AE16"))
                    ResultsOut += "AE16: Expired Database, Please update database\r\n";
                
                if (ResultsString.IndexOf("AE17") != -1)
                    ResultsOut += "AE17: Unnecessary Suite Error \r\n";
                if (ResultsString.IndexOf("AE19") != -1)
                    ResultsOut += "AE19: Max time for FindSuggestion exceeded \r\n";
                if (ResultsString.IndexOf("AE20") != -1)
                    ResultsOut += "AE20: FindSuggestion cannot be used\r\n";
            }

            // a change was made to the address
            if (ResultsString.IndexOf("AC01") != -1)
                ResultsOut += "AC01: ZIP Code Change \r\n";
            if (ResultsString.IndexOf("AC02") != -1)
                ResultsOut += "AC02: State Change\r\n";
            if (ResultsString.IndexOf("AC03") != -1)
                ResultsOut += "AC03: City Change \r\n";
            if (ResultsString.IndexOf("AC04") != -1)
                ResultsOut += "AC04: Base/Alternate Change \r\n";
            if (ResultsString.IndexOf("AC05") != -1)
                ResultsOut += "AC05: Alias Name Change \r\n";
            if (ResultsString.IndexOf("AC06") != -1)
                ResultsOut += "AC06: Address1/Address2 Swap\r\n";
            if (ResultsString.IndexOf("AC07") != -1)
                ResultsOut += "AC07: Address1/Company Swap \r\n";
            if (ResultsString.IndexOf("AC08") != -1)
                ResultsOut += "AC08: Plus4 Change\r\n";
            if (ResultsString.IndexOf("AC09") != -1)
                ResultsOut += "AC09: Urbanization Change \r\n";
            if (ResultsString.IndexOf("AC10") != -1)
                ResultsOut += "AC10: Street Name Change \r\n";
            if (ResultsString.IndexOf("AC11") != -1)
                ResultsOut += "AC11: Street Suffix Change\r\n";
            if (ResultsString.IndexOf("AC12") != -1)
                ResultsOut += "AC12: Street Directional Change \r\n";
            if (ResultsString.IndexOf("AC13") != -1)
                ResultsOut += "AC13: Suite Name Change\r\n";

            txtResultCodes.Text = ResultsOut;

            string other = "";
            other += "Carrier Route: " + addrobj.CarrierRoute + "\r\n";
            other += "Delivery Point Code: " + addrobj.DeliveryPointCode + "\r\n";
            other += "Delivery Point CheckDigit: " + addrobj.DeliveryPointCheckDigit + "\r\n";
            other += "DPV Footnotes: " + addrobj.DPVFootnotes + "\r\n";
            other += "\r\n";
            other += "Address Type Code: " + addrobj.AddressTypeCode + "\r\n";
            other += "Address Type String: " + addrobj.AddressTypeString + "\r\n";
            other += "City Abbreviation: " + addrobj.CityAbbreviation + "\r\n";
            other += "County Name: " + addrobj.CountyName + "\r\n";
            other += "County Fips: " + addrobj.CountyFips + "\r\n";
            other += "Country Code: " + addrobj.CountryCode + "\r\n";
            other += "Congressional District: " + addrobj.CongressionalDistrict + "\r\n";
            other += "Time Zone: " + addrobj.TimeZone + "\r\n";
            other += "Time Zone Code: " + addrobj.TimeZoneCode + "\r\n";
            other += "Urbanization: " + addrobj.Urbanization + "\r\n";
            other += "Zip Type: " + addrobj.ZipType;
            other += "\r\n";
            other += "MSA: " + addrobj.Msa + "\r\n";
            other += "PMSA: " + addrobj.Pmsa + "\r\n";
            other += "Private Mailbox: " + addrobj.PrivateMailbox + "\r\n";
            other += "\r\n";
            other += "Parsed Address Range: " + addrobj.ParsedAddressRange + "\r\n";
            other += "Parsed Pre Direction: " + addrobj.ParsedPreDirection + "\r\n";
            other += "Parsed Street Name: " + addrobj.ParsedStreetName + "\r\n";
            other += "Parsed Suffix: " + addrobj.ParsedSuffix + "\r\n";
            other += "Parsed Post Direction: " + addrobj.ParsedPostDirection + "\r\n";
            other += "Parsed Suite Name: " + addrobj.ParsedSuiteName + "\r\n";
            other += "Parsed Suite Range: " + addrobj.ParsedSuiteRange + "\r\n";
            other += "Parsed Garbage: " + addrobj.ParsedGarbage + "\r\n";
            other += "\r\n";
            other += "ELot Order: " + addrobj.ELotOrder + "\r\n";
            other += "ELot Number: " + addrobj.ELotNumber + "\r\n";
            other += "LACS: " + addrobj.Lacs + "\r\n";
            other += "LACSLinkIndicator: " + addrobj.LACSLinkIndicator + "\r\n";
            other += "LACSLinkReturnCode: " + addrobj.LACSLinkReturnCode + "\r\n";
            other += "EWS: " + addrobj.EWSFlag + "\r\n";
            other += "RBDI: " + addrobj.RBDI + "\r\n";
            other += "Suite Link Return Code: " + addrobj.SuiteLinkReturnCode + "\r\n";
            
            txtOther.Text = other;
        }

        private void AddressClear()
        {
            txtAddressOut.Text = "";
            txtAddress2Out.Text = "";
            txtCityOut.Text = "";
            txtStateOut.Text = "";
            txtZipOut.Text = "";
            txtPlus4.Text = "";
            txtOther.Text = "";
        }
        #endregion

        #region Parse
        bool parseFlag = false;  //This is a flag for trying to reparse without initially calling parse
                                 //True if can reparse, false if not.
        private void btnParse_Click(object sender, System.EventArgs e)
        {        
            if (parseObj.Parse(txtParseAddress.Text) != 0)
            {
                // parse successful
                lblParseGarbage.Text = parseObj.Garbage;
                lblParseSuitenumber.Text = parseObj.SuiteNumber;
                lblParseSuffix.Text = parseObj.Suffix;
                lblParseSuitename.Text = parseObj.SuiteName;
                lblParsePredir.Text = parseObj.PreDirection;
                lblParseStreet.Text = parseObj.StreetName;
                lblParseRange.Text = parseObj.Range;
                lblParsePostdir.Text = parseObj.PostDirection;

                parseFlag = true; //Can now reparse
            }
            
        }

        private void btnReparse_Click(object sender, System.EventArgs e)
        {
            if (parseFlag == true)
            {
                if (parseObj.ParseNext() != 0)
                {
                    //reparses avaliable
                    lblParseGarbage.Text = parseObj.Garbage;
                    lblParseSuitenumber.Text = parseObj.SuiteNumber;
                    lblParseSuffix.Text = parseObj.Suffix;
                    lblParseSuitename.Text = parseObj.SuiteName;
                    lblParsePredir.Text = parseObj.PreDirection;
                    lblParseStreet.Text = parseObj.StreetName;
                    lblParseRange.Text = parseObj.Range;
                    lblParsePostdir.Text = parseObj.PostDirection;
                }
            else parseFlag = false;
            }
        }

        private void btnLastLine_Click(object sender, System.EventArgs e)
        {
            parseObj.LastLineParse(txtLastLine.Text);
            lblParseState.Text = parseObj.State;
            lblParseCity.Text = parseObj.City;
            lblParsePlus4.Text = parseObj.Plus4;
            lblParseZip.Text = parseObj.Zip;
        }
        #endregion

        #region StreetData
        private void btnFindStreet_Click(object sender, System.EventArgs e)
        {
            txtResults.Text = "";

             if (streetObj.FindStreet(txtStreetStreet.Text, txtStreetZip.Text, 0) != 0)
            {
                string output = "";
                output += streetObj.PrimaryRangeLow + "-";
                output += streetObj.PrimaryRangeHigh + "      ";
                output += streetObj.PrimaryRangeOddEven + "   ";
                output += streetObj.PreDirection + "   ";
                output += streetObj.StreetName + "   ";
                output += streetObj.Suffix + "   ";
                output += streetObj.PostDirection + "   ";
                if (streetObj.SuiteName == "" && streetObj.SuiteRangeLow == "")
                    output += "   ";
                else
                {
                    output += streetObj.SuiteName.Trim() + "  ";
                    output += streetObj.SuiteRangeLow.Trim() + "-";
                    output += streetObj.SuiteRangeHigh.Trim() + "  ";
                }
                output += streetObj.Zip + "   ";
                output += streetObj.Plus4Low + "-";
                output += streetObj.Plus4High + "\r\n";

                txtResults.Text += output;
            }
            else
            {
                txtResults.Text = "No Street Data found";
                return;
            }

            //loop through all streets
            while (streetObj.FindStreetNext() != 0)
            {
                string output = "";
                output += streetObj.PrimaryRangeLow + "-";
                output += streetObj.PrimaryRangeHigh + "      ";
                output += streetObj.PrimaryRangeOddEven + "   ";
                output += streetObj.PreDirection + "   ";
                output += streetObj.StreetName + "   ";
                output += streetObj.Suffix + "   ";
                output += streetObj.PostDirection + "   ";
                if (streetObj.SuiteName == "" && streetObj.SuiteRangeLow == "")
                    output += "   ";
                else
                {
                    output += streetObj.SuiteName.Trim() + "  ";
                    output += streetObj.SuiteRangeLow.Trim() + "-";
                    output += streetObj.SuiteRangeHigh.Trim() + "  ";
                }
                output += streetObj.Zip + "   ";
                output += streetObj.Plus4Low + "-";
                output += streetObj.Plus4High + "\r\n";

                txtResults.Text += output;
            }

        }
        #endregion

        #region Zip Data
        private void btnCityInState_Click(object sender, System.EventArgs e)
        {
            txtZipResult.Text = "";

            //call FindCityInState
            if (zipObj.FindCityInState(txtZipCity.Text, txtZipState.Text) != 0)
            {
                //search successful
                txtZipResult.Text += zipObj.City + " - " + zipObj.State + "\r\n";
            }
            //loop through all found cities
            while (zipObj.FindCityInStateNext() != 0)
            {
                txtZipResult.Text += zipObj.City + " - " + zipObj.State + "\r\n";
            }
        }

        private void btnZipInCity_Click(object sender, System.EventArgs e)
        {
            txtZipResult.Text = "";

            //call FindZipinCity
            if (zipObj.FindZipInCity(txtZipCity.Text, txtZipState.Text) != 0)
            {
                //search successful
                txtZipResult.Text += zipObj.Zip + " - " + zipObj.City + " - " + zipObj.State + " - " + zipObj.CountyFips + " - " + zipObj.CountyName + " - " + zipObj.Latitude + " - " + zipObj.Longitude + " - " + zipObj.LastLineIndicator + "\r\n";
            }
            //loop through all found zips
            while (zipObj.FindZipInCityNext() != 0)
            {
                txtZipResult.Text += zipObj.Zip + " - " + zipObj.City + " - " + zipObj.State + " - " + zipObj.CountyFips + " - " + zipObj.CountyName + " - " + zipObj.Latitude + " - " + zipObj.Longitude + " - " + zipObj.LastLineIndicator + "\r\n";
            }
        }

        private void btnFindZip_Click(object sender, System.EventArgs e)
        {
            txtZipResult.Text = "";

            //call FindZipinCity
            if (zipObj.FindZip(txtZipZip.Text, 0) != 0)
            {
                //search successful
                txtZipResult.Text += zipObj.Zip + " - " + zipObj.City + " - " + zipObj.State + " - " + zipObj.CountyFips + " - " + zipObj.CountyName + " - " + zipObj.Latitude + " - " + zipObj.Longitude + " - " + zipObj.LastLineIndicator + "\r\n";
            }
            //loop through all found zips
            while (zipObj.FindZipNext() != 0)
            {
                txtZipResult.Text += zipObj.Zip + " - " + zipObj.City + " - " + zipObj.State + " - " + zipObj.CountyFips + " - " + zipObj.CountyName + " - " + zipObj.Latitude + " - " + zipObj.Longitude + " - " + zipObj.LastLineIndicator + "\r\n";
            }
        }
        #endregion

        private void tabPage1_Click(object sender, EventArgs e)
        {

        }
    }
}